/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain;

import com.utility.ConvertStr;

public class InstalmentSettleDto {
    private int id;
    private int index;
    private String settleDate;
    private String settleTime;
    private Double cash;
    private String cashHeading;
    private Double pos;
    private String posHeading;
    private Double discount;
    private String discountHeading;
    private String comment;
    private boolean withDoc = true;
    private Long userCode;
    private String customerCode;
    private long docCode;
    private boolean isOurPayment;
    private String docCodeC;

    public double calcPaidAmount() {
        return ConvertStr.nullSafeDouble((Double)this.cash) + ConvertStr.nullSafeDouble((Double)this.pos);
    }

    public double calcInstalmentAmount() {
        if (ConvertStr.nullSafeDouble((Double)this.discount) <= 0.0) {
            return -1.0;
        }
        if (ConvertStr.nullSafeDouble((Double)this.cash) <= 0.0 && ConvertStr.nullSafeDouble((Double)this.pos) <= 0.0) {
            return -1.0;
        }
        return this.calcPaidAmount();
    }

    public double sumAllAmounts() {
        return ConvertStr.nullSafeDouble((Double)this.cash) + ConvertStr.nullSafeDouble((Double)this.pos) + ConvertStr.nullSafeDouble((Double)this.discount);
    }

    public double getCashNullSafe() {
        return ConvertStr.nullSafeDouble((Double)this.cash);
    }

    public double getPosNullSafe() {
        return ConvertStr.nullSafeDouble((Double)this.pos);
    }

    public double getDiscountNullSafe() {
        return ConvertStr.nullSafeDouble((Double)this.discount);
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSettleDate() {
        return this.settleDate;
    }

    public String getSettleTime() {
        return this.settleTime;
    }

    public Double getCash() {
        return this.cash;
    }

    public String getCashHeading() {
        return this.cashHeading;
    }

    public Double getPos() {
        return this.pos;
    }

    public String getPosHeading() {
        return this.posHeading;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public String getDiscountHeading() {
        return this.discountHeading;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isWithDoc() {
        return this.withDoc;
    }

    public Long getUserCode() {
        return this.userCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public long getDocCode() {
        return this.docCode;
    }

    public boolean isOurPayment() {
        return this.isOurPayment;
    }

    public String getDocCodeC() {
        return this.docCodeC;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setSettleDate(String settleDate) {
        this.settleDate = settleDate;
    }

    public void setSettleTime(String settleTime) {
        this.settleTime = settleTime;
    }

    public void setCash(Double cash) {
        this.cash = cash;
    }

    public void setCashHeading(String cashHeading) {
        this.cashHeading = cashHeading;
    }

    public void setPos(Double pos) {
        this.pos = pos;
    }

    public void setPosHeading(String posHeading) {
        this.posHeading = posHeading;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public void setDiscountHeading(String discountHeading) {
        this.discountHeading = discountHeading;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setWithDoc(boolean withDoc) {
        this.withDoc = withDoc;
    }

    public void setUserCode(Long userCode) {
        this.userCode = userCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setDocCode(long docCode) {
        this.docCode = docCode;
    }

    public void setOurPayment(boolean isOurPayment) {
        this.isOurPayment = isOurPayment;
    }

    public void setDocCodeC(String docCodeC) {
        this.docCodeC = docCodeC;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstalmentSettleDto)) {
            return false;
        }
        InstalmentSettleDto other = (InstalmentSettleDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.isWithDoc() != other.isWithDoc()) {
            return false;
        }
        if (this.getDocCode() != other.getDocCode()) {
            return false;
        }
        if (this.isOurPayment() != other.isOurPayment()) {
            return false;
        }
        Double this$cash = this.getCash();
        Double other$cash = other.getCash();
        if (this$cash == null ? other$cash != null : !((Object)this$cash).equals(other$cash)) {
            return false;
        }
        Double this$pos = this.getPos();
        Double other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !((Object)this$pos).equals(other$pos)) {
            return false;
        }
        Double this$discount = this.getDiscount();
        Double other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$userCode = this.getUserCode();
        Long other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !((Object)this$userCode).equals(other$userCode)) {
            return false;
        }
        String this$settleDate = this.getSettleDate();
        String other$settleDate = other.getSettleDate();
        if (this$settleDate == null ? other$settleDate != null : !this$settleDate.equals(other$settleDate)) {
            return false;
        }
        String this$settleTime = this.getSettleTime();
        String other$settleTime = other.getSettleTime();
        if (this$settleTime == null ? other$settleTime != null : !this$settleTime.equals(other$settleTime)) {
            return false;
        }
        String this$cashHeading = this.getCashHeading();
        String other$cashHeading = other.getCashHeading();
        if (this$cashHeading == null ? other$cashHeading != null : !this$cashHeading.equals(other$cashHeading)) {
            return false;
        }
        String this$posHeading = this.getPosHeading();
        String other$posHeading = other.getPosHeading();
        if (this$posHeading == null ? other$posHeading != null : !this$posHeading.equals(other$posHeading)) {
            return false;
        }
        String this$discountHeading = this.getDiscountHeading();
        String other$discountHeading = other.getDiscountHeading();
        if (this$discountHeading == null ? other$discountHeading != null : !this$discountHeading.equals(other$discountHeading)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$customerCode = this.getCustomerCode();
        String other$customerCode = other.getCustomerCode();
        if (this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode)) {
            return false;
        }
        String this$docCodeC = this.getDocCodeC();
        String other$docCodeC = other.getDocCodeC();
        return !(this$docCodeC == null ? other$docCodeC != null : !this$docCodeC.equals(other$docCodeC));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstalmentSettleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getIndex();
        result = result * 59 + (this.isWithDoc() ? 79 : 97);
        long $docCode = this.getDocCode();
        result = result * 59 + (int)($docCode >>> 32 ^ $docCode);
        result = result * 59 + (this.isOurPayment() ? 79 : 97);
        Double $cash = this.getCash();
        result = result * 59 + ($cash == null ? 43 : ((Object)$cash).hashCode());
        Double $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : ((Object)$pos).hashCode());
        Double $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : ((Object)$userCode).hashCode());
        String $settleDate = this.getSettleDate();
        result = result * 59 + ($settleDate == null ? 43 : $settleDate.hashCode());
        String $settleTime = this.getSettleTime();
        result = result * 59 + ($settleTime == null ? 43 : $settleTime.hashCode());
        String $cashHeading = this.getCashHeading();
        result = result * 59 + ($cashHeading == null ? 43 : $cashHeading.hashCode());
        String $posHeading = this.getPosHeading();
        result = result * 59 + ($posHeading == null ? 43 : $posHeading.hashCode());
        String $discountHeading = this.getDiscountHeading();
        result = result * 59 + ($discountHeading == null ? 43 : $discountHeading.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $customerCode = this.getCustomerCode();
        result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
        String $docCodeC = this.getDocCodeC();
        result = result * 59 + ($docCodeC == null ? 43 : $docCodeC.hashCode());
        return result;
    }

    public String toString() {
        return "InstalmentSettleDto(id=" + this.getId() + ", index=" + this.getIndex() + ", settleDate=" + this.getSettleDate() + ", settleTime=" + this.getSettleTime() + ", cash=" + this.getCash() + ", cashHeading=" + this.getCashHeading() + ", pos=" + this.getPos() + ", posHeading=" + this.getPosHeading() + ", discount=" + this.getDiscount() + ", discountHeading=" + this.getDiscountHeading() + ", comment=" + this.getComment() + ", withDoc=" + this.isWithDoc() + ", userCode=" + this.getUserCode() + ", customerCode=" + this.getCustomerCode() + ", docCode=" + this.getDocCode() + ", isOurPayment=" + this.isOurPayment() + ", docCodeC=" + this.getDocCodeC() + ")";
    }
}

